#!/bin/bash

# Source: https://help.nixstats.com/en/article/uninstall-the-monitoring-agent-1iygnn3/

set -o nounset  # Treat unset variables as an error

logfile="nixstatsagent.log"

#: Check root privilege :#
if [ "$(id -u)" != "0" ]; then
   echo "error: Uninstaller needs 'root' permission to run, please run as 'root'."
   exit 1
fi

# TODO: Remove the WHM Service Monitor for the agent

rpm --quiet --query systemd
systemd_rc=$?
# Stop the agent and remove the service
if [ "$systemd_rc" == "0" ]; then
    # systemd
    echo 'cleaning up systemd service'
    systemctl stop nixstatsagent
    systemctl disable nixstatsagent
    rm -f /etc/systemd/system/nixstatsagent
else
    # sysvinit
    echo 'cleaning up sysv service'
    service nixstatsagent stop
    update-rc.d -f nixstatsagent remove
    rm -f /etc/init.d/nixstatsagent
fi

# Remove the agents code
echo "Uninstalling nixstatsagent ... "
pip3 list --format=columns | grep -F nixstatsagent
rc=$?
if [ "$rc" != "0" ]; then
    # We found the agents pip module
    command pip3 uninstall -y nixstatsagent >>$logfile 2>&1
    rc=$?
    if [ "$rc" != "0" ] && [ "$rc" != "127" ]; then
        echo pip uninstall of nixstatsagent returned error $?. Please see $logfile for details. $rc
        exit
    fi
fi

# Cleanup the configuration files
rm -f /etc/nixstats.ini
rm -f /etc/nixstats-token.ini

# If the user exists
getent passwd nixstats
rc=$?
if [ "$rc" != "0" ]; then
    userdel nixstats
fi

exit 0;