#!/bin/bash

set -o nounset  # Treat unset variables as an error

# Check root privilege
if [ "$(id -u)" != "0" ];
then
   echo "error: Installer needs 'root' permission to run, please run as 'root'."
   exit 1
fi

# Prepopulate the configuration with a clean one.
if [ ! -f /etc/nixstats.ini ]; then
    cp /var/cpanel/plugins/monitoring-agent/nixstats.ini /etc/nixstats.ini
    touch /var/log/nixstatsagent.log

    id nixstats &>/dev/null
    if [[ $? -ne 0 ]]; then
        useradd --system --user-group --key USERGROUPS_ENAB=yes -M nixstats --shell /bin/false
    fi

    chown nixstats:nixstats /var/log/nixstatsagent.log
    chown nixstats:nixstats /etc/nixstats.ini
    chmod +r /etc/nixstats.ini
fi

# TODO: Configure the nixstats.ini based on the servers current configuration


if [ $# -lt 1 ]; then
    echo "Userid parameter missing."
    exit 1
fi

# Install the nixstats agent and other dependencies
/usr/local/cpanel/scripts/nixstatsagent.sh "$1"
rc=$?
if [ "$rc" != "0" ]; then
    echo nixstatsagent not installed with the error: $?
    exit
fi

#TODO: Consider changing nixstats agent to run as root. We need to explore the implications of this since that means that risky stuff may happen from agent plugins.

#TODO: Setup the WHM service monitoring and enable the service and monitor by default.

exit 0;
