
#!/bin/bash

# Source: https://help.nixstats.com/en/article/upgrading-the-nixstatsagent-uk8nyu/

set -o nounset  # Treat unset variables as an error

#: Check root privilege :#
if [ "$(id -u)" != "0" ];
then
   echo "error: Upgrader needs 'root' permission to run, please run as 'root'."
   exit 1
fi

# TODO: Suspend WHM Service Monitoring so we don't interfer with the upgrade

# TODO: Consider if we need to adjust the nixstats.ini configuration for the upgrade

# Update the agent
pip3 install nixstatsagent --upgrade

# Restart the service
service nixstatsagent restart

# TODO: Restore WHM Service Monitoring

exit 0;